<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrendTaxiAppUserDataTable extends Migration {

	public function up()
	{
		Schema::create('trend_taxi_app_user_data', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unique()->unsigned();
			$table->string('user_image', 255)->nullable();
			$table->string('car_image_1', 255)->nullable();
			$table->string('car_image_2', 255)->nullable();
			$table->string('license_image', 255)->nullable();
			$table->string('driver_license_image', 255)->nullable();
			$table->string('car_usage_license_image', 255)->nullable();
			$table->string('car_type', 24)->nullable();
			$table->string('car_plate', 24)->nullable();
			$table->string('car_brand', 32)->nullable();
			$table->string('car_model', 32)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('trend_taxi_app_user_data');
	}
}