<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrendTaxiAppUsersTable extends Migration {

	public function up()
	{
		Schema::create('trend_taxi_app_users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('user_phone', 12)->unique();
			$table->string('user_verified_code', 6)->nullable();
			$table->tinyInteger('user_status')->default('0');
			$table->enum('user_type', array('wait', 'driver', 'passenger', 'admin', 'taxipark'));
			$table->string('user_device', 255)->nullable();
			$table->string('user_name', 64)->nullable();
			$table->decimal('user_balance', 15,2)->nullable()->default('0.00');
			$table->decimal('user_score', 1,2)->nullable()->default('5');
			$table->string('last_latitude', 24)->nullable();
			$table->string('last_longitude', 24)->nullable();
			$table->string('last_activity', 24)->nullable();
			$table->string('user_taxi_park', 64)->default('trend_taxi');
		});
	}

	public function down()
	{
		Schema::drop('trend_taxi_app_users');
	}
}