<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InvoiceItems extends Eloquent {

	protected $table = 'invoice_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'quantity', 'price', 'invoice_id', 'description');

	public function invoice()
	{
		return $this->belongsTo('Invoice', 'invoice_id');
	}

}