<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Quotation extends Eloquent {

	protected $table = 'quotation';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'client_id', 'notes', 'price', 'total', 'expired_at');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

	public function items()
	{
		return $this->hasMany('QuotationItems', 'quotation_id');
	}

}