<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('task_name');
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('member');
			$table->enum('status', array('running', 'pending', 'done'));
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}