<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Doctor extends Model 
{

    protected $table = 'Doctors';
    public $timestamps = true;

    public function clinic()
    {
        return $this->belongsTo('Clinic', 'clinic_id');
    }

    public function specialty()
    {
        return $this->belongsTo('Specialty', 'specialty_id');
    }

    public function type_of_specialty()
    {
        return $this->belongsTo('Type_of_specialty', 'type_of_specialty_id');
    }

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function discount()
    {
        return $this->morphOne('Discount');
    }

}