<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('card_id')->unsigned();
			$table->integer('amount');
			$table->enum('state', array('complete', 'faild'));
			$table->integer('amount_paid');
			$table->enum('paid_type', array('wallet', 'regular'));
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}