<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRegularCardsTable extends Migration {

	public function up()
	{
		Schema::create('regular_cards', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('number')->unique();
			$table->date('expiry_date');
			$table->string('photo');
			$table->integer('balance');
			$table->tinyInteger('home_run')->default('0');
			$table->integer('home_run_price')->nullable();
			$table->integer('currency_id')->unsigned();
			$table->tinyInteger('status')->default('0');
			$table->integer('grace_period');
			$table->timestamps();
			$table->integer('first_amount_currency');
			$table->integer('last_amount_currency');
			$table->integer('first_pay');
			$table->integer('last_pay');
			$table->integer('period');
			$table->string('content');
			$table->tinyInteger('qr')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('regular_cards');
	}
}