<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClassifiedDepartmentFieldsTable extends Migration {

	public function up()
	{
		Schema::create('classified_department_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->enum('type', array('checkbox', 'radio', 'text', 'number'));
			$table->string('placeholder', 255)->nullable();
			$table->bigInteger('min')->nullable();
			$table->bigInteger('max')->nullable();
			$table->json('values')->nullable();
			$table->boolean('required')->default(false);
			$table->boolean('searched')->default(false);
			$table->bigInteger('classified_department_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('classified_department_fields');
	}
}