<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateElementsTable extends Migration {

	public function up()
	{
		Schema::create('elements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('description')->nullable();
			$table->string('email')->nullable();
			$table->json('phones')->nullable();
			$table->string('time_open')->nullable();
			$table->string('address')->nullable();
			$table->string('logo')->nullable();
			$table->json('images')->nullable();
			$table->string('video')->nullable();
			$table->string('facebook')->nullable();
			$table->string('twitter')->nullable();
			$table->string('youtube')->nullable();
			$table->string('website')->nullable();
			$table->string('instagram')->nullable();
			$table->string('location')->nullable();
			$table->bigInteger('affiliate_id')->unsigned()->nullable();
			$table->boolean('approved_admin');
			$table->bigInteger('number_of_visitors');
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('yellow_page_department_id')->unsigned();
			$table->bigInteger('affiliate_client_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('elements');
	}
}