<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLanguagesTable extends Migration {

	public function up()
	{
		Schema::create('languages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('language');
			$table->enum('read_write_level', array('Intermediate', 'Good', 'VeryGood', 'Exellent'));
			$table->enum('listen_speak_level', array('Intermediate', 'Good', 'VeryGood', 'Exellent'));
			$table->bigInteger('cv_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('languages');
	}
}