<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQualificationsTable extends Migration {

	public function up()
	{
		Schema::create('qualifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('educational_level', array('BasicEducation', 'Bachelor', 'Institute', 'College'));
			$table->string('institute_degree')->nullable();
			$table->string('college_name')->nullable();
			$table->string('department_name')->nullable();
			$table->date('graduation_date')->nullable();
			$table->string('GPA');
			$table->string('current_job');
			$table->enum('type_job', array('public', 'spicial'));
			$table->string('year_of_experience')->nullable();
			$table->bigInteger('cv_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('qualifications');
	}
}