<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisitorMessagesTable extends Migration {

	public function up()
	{
		Schema::create('visitor_messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('subject');
			$table->string('image')->nullable();
			$table->text('comment');
			$table->enum('status', array('enable', 'disable'));
		});
	}

	public function down()
	{
		Schema::drop('visitor_messages');
	}
}