<?php

class Advertisement extends Eloquent {

	protected $table = 'advertisements';
	public $timestamps = true;
	protected $fillable = array('image', 'size', 'site_language_id', 'country_id', 'advertisement_category_id');

	public function siteLanguage()
	{
		return $this->belongsTo('SiteLanguage');
	}

	public function country()
	{
		return $this->belongsTo('Country');
	}

	public function yellowPageAdvertisement()
	{
		return $this->hasOne('YellowPageAdvertisement');
	}

	public function yellowPageDepartmentAdvertisement()
	{
		return $this->hasOne('YellowPageDepartmentAdvertisement');
	}

}