<?php

class Affiliate extends Eloquent {

	protected $table = 'affiliates';
	public $timestamps = true;
	protected $fillable = array('active', 'profit_ratio', 'income_tax', 'attachments', 'contract_signed', 'city_id', 'user_id');

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function transfers()
	{
		return $this->hasMany('AffiliateTransferToAdmin');
	}

	public function affiliateClients()
	{
		return $this->hasMany('AffiliateClient');
	}

	public function affiliateBalanceNotReceived()
	{
		return $this->hasOne('AffiliateBalanceNotReceived');
	}

	public function affiliateBalanceReceived()
	{
		return $this->hasOne('AffiliateBalanceReceived');
	}

	public function transfersFromAdmin()
	{
		return $this->hasMany('AdminTransferToAffiliate');
	}

}