<?php

class ClassifiedDepartment extends Eloquent {

	protected $table = 'classified_departments';
	public $timestamps = true;
	protected $fillable = array('name', 'classified_id');

	public function classified()
	{
		return $this->belongsTo('Classified', 'classified_id');
	}

	public function classifiedDepartmentFields()
	{
		return $this->hasMany('ClassifiedDepartmentField');
	}

	public function posts()
	{
		return $this->hasMany('Post');
	}

	public function advertisements()
	{
		return $this->hasMany('ClassifiedDepartmentAdvertisement', 'classified_department_id');
	}

	public function cvs()
	{
		return $this->hasMany('Cv');
	}

}