<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ClassifiedDepartmentField extends Eloquent {

	protected $table = 'classified_department_fields';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'type', 'placeholder', 'min', 'max', 'values', 'required', 'searched', 'classified_department_id');

	public function classifiedDepartment()
	{
		return $this->belongsTo('ClassifiedDepartment');
	}

}