<?php

class Cv extends Eloquent {

	protected $table = 'cvs';
	public $timestamps = true;
	protected $fillable = array('color_of_cv', 'classified_department_id', 'city_id');

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function classifiedDepartment()
	{
		return $this->belongsTo('ClassifiedDepartment');
	}

	public function personalInformations()
	{
		return $this->hasMany('PersonalInformation', 'cv_id');
	}

	public function computerSkills()
	{
		return $this->hasMany('ComputerSkill', 'cv_id');
	}

	public function interests()
	{
		return $this->hasMany('Interest', 'cv_id');
	}

	public function skills()
	{
		return $this->hasMany('Skill', 'cv_id');
	}

	public function qualifications()
	{
		return $this->hasMany('Qualification', 'cv_id');
	}

	public function softSkills()
	{
		return $this->hasMany('SoftSkill', 'cv_id');
	}

	public function languages()
	{
		return $this->hasMany('Language', 'cv_id');
	}

	public function workExperiences()
	{
		return $this->hasMany('WorkExperience', 'cv_id');
	}

}