<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'phone', 'email', 'password', 'birthday');

	public function affiliate()
	{
		return $this->hasOne('Affiliate');
	}

}