<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Element extends Model 
{

    protected $table = 'elements';
    public $timestamps = true;
    protected $fillable = array('name', 'description', 'email', 'phones', 'time_open', 'address', 'logo', 'images', 'video', 'facebook', 'twitter', 'youtube', 'website', 'instagram', 'location', 'affiliate_id', 'approved_admin', 'city_id', 'yellow_page_department_id', 'affiliate_client_id');

    public function yellowPageDepartment()
    {
        return $this->belongsTo('YellowPageDepartment', 'yellow_page_department_id');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function affiliate()
    {
        return $this->belongsTo('Affiliate', 'affiliate_id', 'id');
    }

    public function affiliateClient()
    {
        return $this->hasOne('AffiliateClient', 'affiliate_client_id', 'id');
    }

}