<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;
    protected $fillable = array('title', 'price', 'description', 'email', 'facebook', 'location', 'mobiles', 'address', 'status', 'images', 'video', 'number_of_visitors', 'city_id', 'classified_department_id', 'currency_id');

    public function classifiedDepartment()
    {
        return $this->belongsTo('ClassifiedDepartment', 'classified_department_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id', 'id');
    }

    public function currency()
    {
        return $this->belongsTo('Currency');
    }

}