<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('car_specifcations', function(Blueprint $table) {
			$table->foreign('car_model_id')->references('id')->on('Cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('car_feature', function(Blueprint $table) {
			$table->foreign('feature_id')->references('id')->on('featureCar')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('car_feature', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('Cars')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('car_specifcations', function(Blueprint $table) {
			$table->dropForeign('car_specifcations_car_model_id_foreign');
		});
		Schema::table('car_feature', function(Blueprint $table) {
			$table->dropForeign('car_feature_feature_id_foreign');
		});
		Schema::table('car_feature', function(Blueprint $table) {
			$table->dropForeign('car_feature_car_id_foreign');
		});
	}
}