<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InstantClosure extends Eloquent {

	protected $table = 'instant_closure';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('description', 'due_date', 'responsible_id', 'closure_date', 'incident_id', 'type', 'status');

	public function responsible()
	{
		return $this->belongsTo('Engineer', 'responsible_id');
	}

	public function incident()
	{
		return $this->belongsTo('Incident', 'incident_id');
	}

}