<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Statistic extends Eloquent {

	protected $table = 'statistic';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'man_power', 'man_hour', 'date');

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

}