<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nome', 20);
			$table->string('cognome', 20);
			$table->string('email', 100);
			$table->date('datanascita');
			$table->integer('plan')->default('0');
			$table->string('fotopath', 300);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}