<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehicleTypeTable extends Migration {

	public function up()
	{
		Schema::create('vehicle_type', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('type');
			$table->string('name', 191)->nullable();
			$table->double('capacity');
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vehicle_type');
	}
}