<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReleasesTable extends Migration {

	public function up()
	{
		Schema::create('releases', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('profile_id')->unsigned()->nullable();
			$table->string('artist');
			$table->string('title');
			$table->longText('description')->nullable();
			$table->datetimeTz('release_date');
			$table->string('link')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('releases');
	}
}