<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pelanggan', function(Blueprint $table) {
			$table->foreign('id_daya')->references('id')->on('daya')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pelanggan', function(Blueprint $table) {
			$table->foreign('id_progress')->references('id')->on('progress')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('id_pelanggan')->references('id')->on('pelanggan')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('upload', function(Blueprint $table) {
			$table->foreign('id_history')->references('id')->on('history')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('pelanggan', function(Blueprint $table) {
			$table->dropForeign('pelanggan_id_daya_foreign');
		});
		Schema::table('pelanggan', function(Blueprint $table) {
			$table->dropForeign('pelanggan_id_progress_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_id_pelanggan_foreign');
		});
		Schema::table('upload', function(Blueprint $table) {
			$table->dropForeign('upload_id_history_foreign');
		});
	}
}