<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('trips', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned()->nullable();
			$table->integer('captain_id')->unsigned()->nullable();
			$table->string('start_address')->nullable();
			$table->string('end_address')->nullable();
			$table->string('start_lat')->nullable();
			$table->string('start_lng')->nullable();
			$table->string('end_lat')->nullable();
			$table->string('end_lng')->nullable();
			$table->integer('class_id')->unsigned()->nullable();
			$table->enum('payment', array('cash', 'wallet'))->nullable();
			$table->integer('coupon_id')->unsigned()->nullable();
			$table->string('total_price')->nullable();
			$table->string('kilos')->nullable();
			$table->string('waiting_minutes')->nullable();
			$table->enum('status', array('waiting', 'captain_accept', 'captain_arrive', 'in_progress', 'cancel', 'finished', 'dropout'))->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->string('trip_code')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('trips');
	}
}