<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripHistoriesTable extends Migration {

	public function up()
	{
		Schema::create('trip_histories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('trip_id')->unsigned();
			$table->enum('type', array('created', 'captain_accept', 'captain_arrive', 'trip_start', 'finished', 'canceled', 'drop_out'))->nullable();
			$table->integer('user_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('trip_histories');
	}
}