<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('mark_id')->unsigned()->nullable();
			$table->integer('model_id')->unsigned()->nullable();
			$table->string('year')->nullable();
			$table->string('seats_count')->nullable();
			$table->integer('class_id')->unsigned()->nullable();
			$table->string('color')->nullable();
			$table->string('plate_number')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}