<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Importer extends Model 
{

    protected $table = 'importers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('last_run_at');

    public function importerLogs()
    {
        return $this->hasMany('ImporterLog');
    }

    public function currencies()
    {
        return $this->hasOne('Currency');
    }

    public function productVariantPrices()
    {
        return $this->hasMany('ProductVariantPrices');
    }

}