<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function productValues()
    {
        return $this->hasMany('ProductValue');
    }

    public function productTypes()
    {
        return $this->hasOne('ProductType');
    }

    public function productVariants()
    {
        return $this->hasMany('ProductVariant');
    }

}