<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserProblemsTable extends Migration {

	public function up()
	{
		Schema::create('user_problems', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->index();
			$table->integer('problem_id')->index();
			$table->jsonb('tags');
			$table->text('content');
			$table->string('location')->nullable();
			$table->jsonb('image_paths')->default('[]');
			$table->string('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_problems');
	}
}