<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkshopsTable extends Migration {

	public function up()
	{
		Schema::create('workshops', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->datetime('start_at');
			$table->string('title', 255);
			$table->text('description')->nullable();
			$table->tinyInteger('online')->default('1');
			$table->smallInteger('price')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('workshops');
	}
}