<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->bigInteger('id', true)->primary();
			$table->string('title', 255)->nullable();
			$table->datetime('date')->nullable();
			$table->string('name', 255);
			$table->string('type', 255)->nullable();
			$table->string('url', 255);
			$table->integer('width')->nullable();
			$table->integer('height')->nullable();
			$table->string('ext', 25)->nullable();
			$table->bigInteger('size');
			$table->string('mime', 100)->nullable();
			$table->integer('duration')->nullable();
			$table->bigInteger('fileable_id')->nullable();
			$table->string('fileable_type', 200)->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}