<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Attendance extends Model 
{

    protected $table = 'Attendances';
    public $timestamps = true;

    public function getAttendanceDay()
    {
        return $this->belongsTo('CampDay');
    }

    public function getAttendanceFeedback()
    {
        return $this->hasOne('CampFeedback');
    }

    public function getAttendancesParticipants()
    {
        return $this->hasMany('Participant');
    }

    public function getAttendanceType()
    {
        return $this->hasOne('AttendantType');
    }

}