<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Participant extends Model 
{

    protected $table = 'Participants';
    public $timestamps = true;

    public function getCamps()
    {
        return $this->hasMany('Camp');
    }

    public function getParticipantAttendances()
    {
        return $this->hasMany('Attendance');
    }

    public function getReferral()
    {
        return $this->belongsTo('Participant');
    }

    public function getParticipantGender()
    {
        return $this->hasOne('Gender');
    }

    public function getParticipantDiet()
    {
        return $this->hasOne('Diet');
    }

    public function getLegalGuardian()
    {
        return $this->belongsTo('LegalGuardian', 'id');
    }

}