<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParticipantsTable extends Migration {

	public function up()
	{
		Schema::create('Participants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('firstname');
			$table->string('lastname');
			$table->string('street');
			$table->smallInteger('zip');
			$table->string('city');
			$table->date('birthdate');
			$table->integer('referral');
			$table->integer('gender');
			$table->integer('diet');
			$table->string('specialities');
			$table->integer('camp_id')->unsigned();
			$table->integer('legal_guardian_id');
		});
	}

	public function down()
	{
		Schema::drop('Participants');
	}
}