<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('features_id')->references('id')->on('features')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coustmer_order_package', function(Blueprint $table) {
			$table->foreign('cousmer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coustmer_order_package', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coustmer_order_package', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_features_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_user_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_user_id_foreign');
		});
		Schema::table('coustmer_order_package', function(Blueprint $table) {
			$table->dropForeign('coustmer_order_package_cousmer_id_foreign');
		});
		Schema::table('coustmer_order_package', function(Blueprint $table) {
			$table->dropForeign('coustmer_order_package_order_id_foreign');
		});
		Schema::table('coustmer_order_package', function(Blueprint $table) {
			$table->dropForeign('coustmer_order_package_package_id_foreign');
		});
	}
}