<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->string('email', 255);
			$table->integer('phone_extension');
			$table->softDeletes();
			$table->timestamps();
			$table->integer('department_id')->unsigned();
			$table->integer('position_id')->unsigned();
			$table->integer('manager_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}