<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255)->unique();
			$table->string('username', 255)->unique();
			$table->string('password', 255);
			$table->timestamps();
			$table->integer('role_id')->unsigned();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}