<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupsTable extends Migration {

	public function up()
	{
		Schema::create('groups', function(Blueprint $table) {
			$table->increments('id');
			$table->char('ulid', 26);
			$table->string('name')->unique();
			$table->string('code', 50)->unique()->nullable();
			$table->string('description')->nullable();
			$table->string('type', 20)->index()->default('corp');
			$table->jsonb('properties')->nullable();
			$table->string('status', 20)->default('active');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('groups');
	}
}