<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectAssignmentsTable extends Migration {

	public function up()
	{
		Schema::create('project_assignments', function(Blueprint $table) {
			$table->increments('id');
			$table->char('ulid', 26)->unique();
			$table->string('code', 50)->nullable();
			$table->bigInteger('project_id')->unsigned();
			$table->bigInteger('entity_id')->unsigned();
			$table->char('entity_ulid');
			$table->bigInteger('workflow_id')->unsigned();
			$table->string('type', 20)->index()->default('rcsa');
			$table->string('status', 20)->default('active');
			$table->jsonb('properties')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('project_assignments');
	}
}