<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkflowStepsTable extends Migration {

	public function up()
	{
		Schema::create('workflow_steps', function(Blueprint $table) {
			$table->increments('id');
			$table->char('ulid', 26);
			$table->string('code', 50)->nullable();
			$table->integer('workflow_id')->unsigned()->index();
			$table->string('description')->nullable();
			$table->string('name', 100);
			$table->string('approval_type', 50);
			$table->string('executor_type', 50);
			$table->string('executor_requirement');
			$table->string('submit_type', 50);
			$table->integer('taxonomy_submit_status_id')->unsigned()->index();
			$table->integer('taxonomy_reject_status_id')->unsigned()->index();
			$table->smallInteger('priority')->default('1');
			$table->integer('reject_terget_priority');
			$table->smallInteger('sort_order')->default('0');
			$table->jsonb('properties')->nullable();
			$table->string('status', 20)->default('active');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('workflow_steps');
	}
}