<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('produits', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commandes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id_user')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ligne_commande', function(Blueprint $table) {
			$table->foreign('commande_id')->references('id')->on('commandes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ligne_commande', function(Blueprint $table) {
			$table->foreign('produit_id')->references('id')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('produits', function(Blueprint $table) {
			$table->dropForeign('produits_categorie_id_foreign');
		});
		Schema::table('commandes', function(Blueprint $table) {
			$table->dropForeign('commandes_user_id_foreign');
		});
		Schema::table('ligne_commande', function(Blueprint $table) {
			$table->dropForeign('ligne_commande_commande_id_foreign');
		});
		Schema::table('ligne_commande', function(Blueprint $table) {
			$table->dropForeign('ligne_commande_produit_id_foreign');
		});
	}
}