<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDevicesTable extends Migration {

	public function up()
	{
		Schema::create('devices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('device_name', 211);
			$table->string('device_id', 211);
			$table->boolean('status');
			$table->boolean('is_active')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('devices');
	}
}