<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'username', 'password', 'role', 'superior_user_id', 'balance_total', 'balance_actual', 'rua', 'bairro', 'cidade');

    public function commission()
    {
        return $this->hasOne('App\Commission');
    }

}