<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGamesTable extends Migration {

	public function up()
	{
		Schema::create('games', function(Blueprint $table) {
			$table->increments('id');
			$table->string('home');
			$table->string('away');
			$table->integer('league_id')->unsigned();
			$table->integer('odd_id')->unsigned();
			$table->string('country_code', 3);
			$table->enum('status', array('upcoming', 'started', 'finished'));
			$table->datetime('start_time');
			$table->boolean('modified')->default(0);
			$table->boolean('hidden')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('games');
	}
}