<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBetsTable extends Migration {

	public function up()
	{
		Schema::create('bets', function(Blueprint $table) {
			$table->increments('id');
			$table->string('token');
			$table->string('client_name')->nullable();
			$table->boolean('validated')->default(0);
			$table->integer('validated_by')->unsigned();
			$table->datetime('validated_at');
			$table->integer('bet_value')->unsigned();
			$table->integer('prize_value')->unsigned();
			$table->string('odd');
			$table->enum('status', array('upcoming', 'fail', 'win'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bets');
	}
}